# -*- coding: utf-8 -*-
"""r10.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1RN2WBNaZHAuocwmYyWFb-zfgLn_4g2-I
"""

import numpy as np
import matplotlib.pyplot as plt

import sympy as sym

import scipy.linalg

import matplotlib.gridspec as gridspec


# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Praca z równaniami macierzowymi"""

A = np.random.randn(4,4)
B = np.random.randn(4,4)

# rozwiązuję równanie (szukam X)
X1 = np.linalg.inv(A) @ B
X2 = B @ np.linalg.inv(A)

# reszty (powinny to być macierze zerowe)
res1 = A@X1 - B
res2 = A@X2 - B

# która z odpowiedzi jest poprawna?
print('res1:'), print(' ')
print( np.round(res1,10) ), print(' ')

print('res2:'), print(' ')
print( np.round(res2,10) )



"""# Zredukowana macierz schodkowa"""

M = np.array([ [1,1,4],[-1/2,1,2] ])

# konwersja macierzy na macierz SymPy
symMat = sym.Matrix(M)
print(symMat)

# zredukowana macierz schodkowa
symMat.rref()[0]



"""# Rozkład LU"""

A = np.array([ [2,2,4], [1,0,3], [2,1,2] ])

# funkcja obliczająca rozkład LU znajduje się w bibliotece SciPy (zignoruj pierwszą zwracaną wartość)
_,L,U = scipy.linalg.lu(A)

# wyświetlam macierze
print('L: ')
print(L), print(' ')

print('U: ')
print(U), print(' ')

print('A - LU: ')
print(A - L@U)

m = 4
n = 6

A = np.random.randn(m,n)

P,L,U = scipy.linalg.lu(A)

fig,axs = plt.subplots(1,5,figsize=(13,4))

axs[0].imshow(A,vmin=-1,vmax=1)
axs[0].set_title('A')

axs[1].imshow(np.ones((m,n)),cmap='gray',vmin=-1,vmax=1)
axs[1].text(n/2,m/2,'=',ha='center',fontsize=30,fontweight='bold')
# axs[1].axis('off')

axs[2].imshow(P.T,vmin=-1,vmax=1)
axs[2].set_title(r'P$^T$')

axs[3].imshow(L,vmin=-1,vmax=1)
axs[3].set_title('L')

h = axs[4].imshow(U,vmin=-1,vmax=1)
axs[4].set_title('U')

for a in axs:
  a.axis('off')
  a.set_xlim([-.5,n-.5])
  a.set_ylim([m-.5,-.5])


fig.colorbar(h,ax=axs[-1],fraction=.05)
plt.tight_layout()
plt.savefig('rys10.1.png',dpi=300)
plt.show()



"""# Ćwiczenie 1."""

# pomiary czasu!

import time

# start
tic = time.time()

# test
for i in range(1000):
  A = np.random.randn(100,100)
  P,L,U = scipy.linalg.lu(A)

# stop
toc = time.time() - tic
toc # wyświetlam wynik w sekundach



"""# Ćwiczenie 2."""

# tworzę macierz wartości losowych o niepełnym rzędzie

# rozmiary i rząd
M = 6
N = 8
r = 3

# tworzę macierz
A = np.random.randn(M,r) @ np.random.randn(r,N)

# LU
P,L,U = scipy.linalg.lu(A)

# wykreślam wyniki
_,axs = plt.subplots(1,3,figsize=(12,7))

axs[0].imshow(A,vmin=-1,vmax=1,cmap='gray')
axs[0].set_title(f'A, rząd={np.linalg.matrix_rank(A)}')

axs[1].imshow(L,vmin=-1,vmax=1,cmap='gray')
axs[1].set_title(f'L, rząd={np.linalg.matrix_rank(L)}')

axs[2].imshow(U,vmin=-1,vmax=1,cmap='gray')
axs[2].set_title(f'U, rząd={np.linalg.matrix_rank(U)}')

plt.tight_layout()
plt.savefig('rys10.2.png',dpi=300)
plt.show()

np.round(L,2)



"""# Ćwiczenie 3."""

# macierz i jej wyznacznik
M = 6
A = np.random.randn(M,M)

# LU
P,L,U = scipy.linalg.lu(A)

# wyznacznik jako iloczyn przekątnych
detLU = np.prod( np.diag(U) ) * np.linalg.det(P)

# na potrzeby porównania obliczam wyznacznik w standardowy sposób
detNP = np.linalg.det(A)

# porównuję
print(detLU,detNP)
print(detLU-detNP)



"""# Ćwiczenie 4."""

# rozmiary macierzy
m = 4
A = np.random.randn(m,m)

# rozkład LU
P,L,U = scipy.linalg.lu(A)

# odwrotność
invViaLU = np.linalg.inv(U) @ np.linalg.inv(L) @ P.T

# "klasyczna" odwrotność
invViaInv = np.linalg.inv(A)

np.round( A@invViaLU ,10)



"""# Ćwiczenie 5."""

# Powodem, dla którego nie musimy korzystać z macierzy permutacji jest to, że
# po rozpisaniu równania w środku znajduje się PtP, czyli macierz jednostkowa.
# Koncepcyjnie oznacza to, że każda zamiana wierszy jest cofana po pomnożeniu przez transpozycję.

# tworzę macierz
A = np.random.randn(4,4)

# LUP
P,L,U = scipy.linalg.lu(A)

# obliczam AtA za pomocą rozkładu LU
AtA_lu = U.T @ L.T @ L @ U

# obliczam AtA w bezpośredni sposób
AtA_direct = A.T @ A

# porównuję wyniki
np.round( AtA_lu - AtA_direct ,10)



